

//@class A source token (to be stored in a list).
class CSrcToken {
private:
	BOOL m_bMatched;

public:
	const char *m_sz;
	int			m_nLen;

	CSrcToken(const char *sz = NULL, int nLen = 0);
	void ResetStart(const char *);
	void ResetEnd(const char *);
	BOOL operator=(CSrcToken &another) { return m_sz == another.m_sz; }
	BOOL operator!=(CSrcToken &another) { return m_sz != another.m_sz; }
	
	BOOL IsEmpty(void) { return m_nLen == 0; }
	void Empty(void) { m_nLen = 0; }

	BOOL IsMatched(void) { return m_bMatched; }
	void SetMatch(void)  { m_bMatched = TRUE; }
};


typedef CTypedPtrArray<CPtrArray, CSrcToken *> CSrcTokenArray;

void ClearSrcTokens(CSrcTokenArray &aTokens);


//@class Base class for describing source items
class CSrcItem
{
public:
	virtual int Match(const char *szSrc, const char *&szCont, BOOL &bMatch) { bMatch = FALSE; return 0; }

	void SetOptional(BOOL bOptional) { m_bOptional = bOptional; }
    BOOL IsOptional(void) { return m_bOptional; }

	CSrcItem(void) { m_bOptional = FALSE; m_pTokenMatch = NULL; }
	~CSrcItem(void);

	virtual BOOL CanMatchDefinite(void) { return FALSE; }
	virtual int Complete(CSrcToken &tokIn, CSrcToken &tokOut, BOOL &bMatch) { tokOut = tokIn; bMatch = FALSE; return 0; }

	void SetMatch(CSrcToken *pMatch)   { m_pTokenMatch = pMatch; }
	BOOL GetMatch(CSrcToken *&pMatch)  { pMatch = m_pTokenMatch; return (pMatch != NULL); }

	CStrArray m_aTokens;

	void Add(const char *szTok, int nLen) { m_aTokens.Add( new CString(szTok, nLen) ); }

	BOOL GetPhrase(CString &s) { s.Empty(); return FALSE; }
	BOOL GetToken(int i, CString &s);

protected:
	BOOL m_bOptional; 

private:
	CSrcToken *m_pTokenMatch;
};

typedef CTypedPtrList<CPtrList, CSrcItem *> CSrcItemList;


class CSrcParens : public CSrcItem
{
private:
	char m_chOpen;
	char m_chClose;

public:
	void SetDelims(char chOpen, char chClose) { m_chOpen = chOpen; m_chClose = chClose; }
	BOOL CanMatchDefinite(void) { return TRUE; }
	int Match(const char *szSrc, const char *&szCont, BOOL &bMatch);
	BOOL GetPhrase(CString &s);
};

//@class A keyword token (can be any one of a list of keywords
// specified in a list).

class CSrcKey : public CSrcItem
{
private:
	const char **m_aszKeys;

public:
	void SetKeyList(const char **aszKeys) { m_aszKeys = aszKeys; }
	int Match(const char *szSrc, const char *&szCont, BOOL &bMatch);
	BOOL CanMatchDefinite(void) { return TRUE; }

	CSrcKey(void) { m_aszKeys = NULL; }

	BOOL GetPhrase(CString &s);
};


//@class A keyword list (can be any one of a list of keywords
// specified in a list).

class CSrcKeyList : public CSrcKey
{
public:
	int Match(const char *szSrc, const char *&szCont, BOOL &bMatch);
	BOOL GetPhrase(CString &s);
};


//@class A keyword followed by an identifier. The first item in
// the list will be the keyword.

class CSrcKeyName : public CSrcKey
{
protected:
	const char *m_szNameExt;

public:
	CSrcKeyName(void) { m_szNameExt = NULL; }
	int Match(const char *szSrc, const char *&szEnd, BOOL &bMatch);
	BOOL GetPhrase(CString &s);
	void SetNameExtensions(const char *szExt) { m_szNameExt = szExt; }
};


//@class A keyword followed by a list of identifiers. The
// first item in the list will be the keyword.

class CSrcKeyNameList : public CSrcKeyName
{
private:
	CString m_chListSep;

public:
	void SetListSeparators(char chSep) { m_chListSep = chSep; }
	int Match(const char *szSrc, const char *&szEnd, BOOL &bMatch);
	BOOL GetPhrase(CString &s);
};


//@class A list of identifiers.

class CSrcName : public CSrcItem
{
protected:
	const char *m_szNameExt;

public:
	CSrcName(void) { m_szNameExt = NULL; }
	int Complete(CSrcToken &tokIn, CSrcToken &tokOut, BOOL &bMatch);
	BOOL GetPhrase(CString &s);
	void SetNameExtensions(const char *szExt) { m_szNameExt = szExt; }
};



//@class An identifier.

class CSrcNameList : public CSrcName
{
public:
	int Complete(CSrcToken &tokIn, CSrcToken &tokOut, BOOL &bMatch);
	BOOL GetPhrase(CString &s);
};




int LinkTokens(const char *szSrc, const char *&szCont, CSrcItemList &lSrcItems, CSrcTokenArray &aSrcTokens, 
	const char *szTermChars);

int CompleteTokens(CSrcItemList &lSrcItems, CSrcTokenArray &aSrcTokens);

